/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineMiddleToEnd.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"


//	Creates a line using the mid point of the given line1 and the
//	end point of the given line2 and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineMiddleToEnd(ILine *line1, ILine *line2, ILine **newLine1)
{

	START_METHOD("CreateLineMiddleToEnd")

	HRESULT status = CONV_SUCCESS;

	// Get the mid point of the first line
	IPoint *midPoint1 = NULL;
	status = GetMidPoint(line1, &midPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the end point of the second line
	IPoint *endPoint1 = NULL;
	status = line2->GetEndPoint(&endPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(midPoint1, endPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineMiddleToEnd")
}
